<?php
use Org\Sms;
use Common\Model\MemberModel;
use Common\Model\Common\Model;
use Home\Model\MemberCouponModel;

// OneThink常量定义
const ONETHINK_VERSION    = '1.1.141101';
const ONETHINK_ADDON_PATH = './Addons/';

/**
 * 系统公共库文件
 * 主要定义系统公共函数库
 */


/**
 * 字符串转换为数组，主要用于把分隔符调整到第二个参数
 * @param  string $str  要分割的字符串
 * @param  string $glue 分割符
 * @return array
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function str2arr($str, $glue = ','){
    return explode($glue, $str);
}

/**
 * 数组转换为字符串，主要用于把分隔符调整到第二个参数
 * @param  array  $arr  要连接的数组
 * @param  string $glue 分割符
 * @return string
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function arr2str($arr, $glue = ','){
    return implode($glue, $arr);
}

/**
 * 字符串截取，支持中文和其他编码
 * @static
 * @access public
 * @param string $str 需要转换的字符串
 * @param string $start 开始位置
 * @param string $length 截取长度
 * @param string $charset 编码格式
 * @param string $suffix 截断显示字符
 * @return string
 */
function msubstr($str, $start=0, $length, $charset="utf-8", $suffix=true) {
    if(function_exists("mb_substr"))
        $slice = mb_substr($str, $start, $length, $charset);
    elseif(function_exists('iconv_substr')) {
        $slice = iconv_substr($str,$start,$length,$charset);
        if(false === $slice) {
            $slice = '';
        }
    }else{
        $re['utf-8']   = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
        $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
        $re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
        $re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
        preg_match_all($re[$charset], $str, $match);
        $slice = join("",array_slice($match[0], $start, $length));
    }
    return $suffix ? $slice.'...' : $slice;
}

/**
 * 系统加密方法
 * @param string $data 要加密的字符串
 * @param string $key  加密密钥
 * @param int $expire  过期时间 单位 秒
 * @return string
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function think_encrypt($data, $key = '', $expire = 0) {
    $key  = md5(empty($key) ? C('DATA_AUTH_KEY') : $key);
    $data = base64_encode($data);
    $x    = 0;
    $len  = strlen($data);
    $l    = strlen($key);
    $char = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    $str = sprintf('%010d', $expire ? $expire + time():0);

    for ($i = 0; $i < $len; $i++) {
        $str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1)))%256);
    }
    return str_replace(array('+','/','='),array('-','_',''),base64_encode($str));
}

/**
 * 系统解密方法
 * @param  string $data 要解密的字符串 （必须是think_encrypt方法加密的字符串）
 * @param  string $key  加密密钥
 * @return string
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function think_decrypt($data, $key = ''){
    $key    = md5(empty($key) ? C('DATA_AUTH_KEY') : $key);
    $data   = str_replace(array('-','_'),array('+','/'),$data);
    $mod4   = strlen($data) % 4;
    if ($mod4) {
       $data .= substr('====', $mod4);
    }
    $data   = base64_decode($data);
    $expire = substr($data,0,10);
    $data   = substr($data,10);

    if($expire > 0 && $expire < time()) {
        return '';
    }
    $x      = 0;
    $len    = strlen($data);
    $l      = strlen($key);
    $char   = $str = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    for ($i = 0; $i < $len; $i++) {
        if (ord(substr($data, $i, 1))<ord(substr($char, $i, 1))) {
            $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
        }else{
            $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
        }
    }
    return base64_decode($str);
}

/**
 * 数据签名认证
 * @param  array  $data 被认证的数据
 * @return string       签名
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function data_auth_sign($data) {
    //数据类型检测
    if(!is_array($data)){
        $data = (array)$data;
    }
    ksort($data); //排序
    $code = http_build_query($data); //url编码并生成query字符串
    $sign = sha1($code); //生成签名
    return $sign;
}

/**
* 对查询结果集进行排序
* @access public
* @param array $list 查询结果
* @param string $field 排序的字段名
* @param array $sortby 排序类型
* asc正向排序 desc逆向排序 nat自然排序
* @return array
*/
function list_sort_by($list,$field, $sortby='asc') {
   if(is_array($list)){
       $refer = $resultSet = array();
       foreach ($list as $i => $data)
           $refer[$i] = &$data[$field];
       switch ($sortby) {
           case 'asc': // 正向排序
                asort($refer);
                break;
           case 'desc':// 逆向排序
                arsort($refer);
                break;
           case 'nat': // 自然排序
                natcasesort($refer);
                break;
       }
       foreach ( $refer as $key=> $val)
           $resultSet[] = &$list[$key];
       return $resultSet;
   }
   return false;
}

/**
 * 把返回的数据集转换成Tree
 * @param array $list 要转换的数据集
 * @param string $pid parent标记字段
 * @param string $level level标记字段
 * @return array
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function list_to_tree($list, $pk='id', $pid = 'pid', $child = '_child', $root = 0) {
    // 创建Tree
    $tree = array();
    if(is_array($list)) {
        // 创建基于主键的数组引用
        $refer = array();
        foreach ($list as $key => $data) {
            $refer[$data[$pk]] =& $list[$key];
        }
        foreach ($list as $key => $data) {
            // 判断是否存在parent
            $parentId =  $data[$pid];
            if ($root == $parentId) {
                $tree[] =& $list[$key];
            }else{
                if (isset($refer[$parentId])) {
                    $parent =& $refer[$parentId];
                    $parent[$child][] =& $list[$key];
                }
            }
        }
    }
    return $tree;
}

/**
 * 将list_to_tree的树还原成列表
 * @param  array $tree  原来的树
 * @param  string $child 孩子节点的键
 * @param  string $order 排序显示的键，一般是主键 升序排列
 * @param  array  $list  过渡用的中间数组，
 * @return array        返回排过序的列表数组
 * @author yangweijie <yangweijiester@gmail.com>
 */
function tree_to_list($tree, $child = '_child', $order='id', &$list = array()){
    if(is_array($tree)) {
        foreach ($tree as $key => $value) {
            $reffer = $value;
            if(isset($reffer[$child])){
                unset($reffer[$child]);
                tree_to_list($value[$child], $child, $order, $list);
            }
            $list[] = $reffer;
        }
        $list = list_sort_by($list, $order, $sortby='asc');
    }
    return $list;
}

/**
 * 格式化字节大小
 * @param  number $size      字节数
 * @param  string $delimiter 数字和单位分隔符
 * @return string            格式化后的带单位的大小
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function format_bytes($size, $delimiter = '') {
    $units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
    for ($i = 0; $size >= 1024 && $i < 5; $i++) $size /= 1024;
    return round($size, 2) . $delimiter . $units[$i];
}

/**
 * 设置跳转页面URL
 * 使用函数再次封装，方便以后选择不同的存储方式（目前使用cookie存储）
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function set_redirect_url($url){
    cookie('redirect_url', $url);
}

/**
 * 获取跳转页面URL
 * @return string 跳转页URL
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function get_redirect_url(){
    $url = cookie('redirect_url');
    return empty($url) ? __APP__ : $url;
}

/**
 * 处理插件钩子
 * @param string $hook   钩子名称
 * @param mixed $params 传入参数
 * @return void
 */
function hook($hook,$params=array()){
    \Think\Hook::listen($hook,$params);
}

/**
 * 获取插件类的类名
 * @param strng $name 插件名
 */
function get_addon_class($name){
    $class = "Addons\\{$name}\\{$name}Addon";
    return $class;
}

/**
 * 获取插件类的配置文件数组
 * @param string $name 插件名
 */
function get_addon_config($name){
    $class = get_addon_class($name);
    if(class_exists($class)) {
        $addon = new $class();
        return $addon->getConfig();
    }else {
        return array();
    }
}

/**
 * 插件显示内容里生成访问插件的url
 * @param string $url url
 * @param array $param 参数
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function addons_url($url, $param = array()){
    $url        = parse_url($url);
    $case       = C('URL_CASE_INSENSITIVE');
    $addons     = $case ? parse_name($url['scheme']) : $url['scheme'];
    $controller = $case ? parse_name($url['host']) : $url['host'];
    $action     = trim($case ? strtolower($url['path']) : $url['path'], '/');

    /* 解析URL带的参数 */
    if(isset($url['query'])){
        parse_str($url['query'], $query);
        $param = array_merge($query, $param);
    }

    /* 基础参数 */
    $params = array(
        '_addons'     => $addons,
        '_controller' => $controller,
        '_action'     => $action,
    );
    $params = array_merge($params, $param); //添加额外参数

    return U('Addons/execute', $params);
}

/**
 * 时间戳格式化
 * @param int $time
 * @return string 完整的时间显示
 * @author huajie <banhuajie@163.com>
 */
function time_format($time = NULL,$format='Y-m-d H:i'){
    $time = $time === NULL ? NOW_TIME : intval($time);
    return date($format, $time);
}

/**
 * 根据用户ID获取用户名
 * @param  integer $uid 用户ID
 * @return string       用户名
 */
function get_username($uid = 0){
    static $list;
    if(!($uid && is_numeric($uid))){ //获取当前登录用户名
        return session('user_auth.username');
    }

    /* 获取缓存数据 */
    if(empty($list)){
        $list = S('sys_active_user_list');
    }

    /* 查找用户信息 */
    $key = "u{$uid}";
    if(isset($list[$key])){ //已缓存，直接使用
        $name = $list[$key];
    } else { //调用接口获取用户信息
        $User = new User\Api\UserApi();
        $info = $User->info($uid);
        if($info && isset($info[1])){
            $name = $list[$key] = $info[1];
            /* 缓存用户 */
            $count = count($list);
            $max   = C('USER_MAX_CACHE');
            while ($count-- > $max) {
                array_shift($list);
            }
            S('sys_active_user_list', $list);
        } else {
            $name = '';
        }
    }
    return $name;
}

/**
 * 根据用户ID获取用户昵称
 * @param  integer $uid 用户ID
 * @return string       用户昵称
 */
function get_nickname($uid = 0){
    static $list;
    if(!($uid && is_numeric($uid))){ //获取当前登录用户名
        return session('user_auth.username');
    }

    /* 获取缓存数据 */
    if(empty($list)){
        $list = S('sys_user_nickname_list');
    }

    /* 查找用户信息 */
    $key = "u{$uid}";
    if(isset($list[$key])){ //已缓存，直接使用
        $name = $list[$key];
    } else { //调用接口获取用户信息
        $info = M('Member')->field('nickname')->find($uid);
        if($info !== false && $info['nickname'] ){
            $nickname = $info['nickname'];
            $name = $list[$key] = $nickname;
            /* 缓存用户 */
            $count = count($list);
            $max   = C('USER_MAX_CACHE');
            while ($count-- > $max) {
                array_shift($list);
            }
            S('sys_user_nickname_list', $list);
        } else {
            $name = '';
        }
    }
    return $name;
}

/**
 * 获取用户信息
 * @param  integer $id    用户ID
 * @param  string  $field 要获取的字段名
 * @return string         用户信息
 */
function get_member($id, $field = null){
    static $list;

    /* 非法分类ID */
    if(empty($id) || !is_numeric($id)){
        return '';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('sys_member_list');
    }

    /* 获取分类名称 */
    if(!isset($list[$id])){
        $info = M('Member')->find($id);
        if(!$info){
            return '';
        }
        $list[$id] = $info;
        S('sys_member_list', $list); //更新缓存
    }
    return is_null($field) ? $list[$id] : $list[$id][$field];
}


/**
 * 获取顶级模型信息
 */
function get_top_model($model_id=null){
    $map   = array('status' => 1, 'extend' => 0);
    if(!is_null($model_id)){
        $map['id']  =   array('neq',$model_id);
    }
    $model = M('Model')->where($map)->field(true)->select();
    foreach ($model as $value) {
        $list[$value['id']] = $value;
    }
    return $list;
}

/**
 * 获取文档模型信息
 * @param  integer $id    模型ID
 * @param  string  $field 模型字段
 * @return array
 */
function get_document_model($id = null, $field = null){
    static $list;

    /* 非法分类ID */
    if(!(is_numeric($id) || is_null($id))){
        return '';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('DOCUMENT_MODEL_LIST');
    }

    /* 获取模型名称 */
    if(empty($list)){
        $map   = array('status' => 1, 'extend' => 1);
        $model = M('Model')->where($map)->field(true)->select();
        foreach ($model as $value) {
            $list[$value['id']] = $value;
        }
        S('DOCUMENT_MODEL_LIST', $list); //更新缓存
    }

    /* 根据条件返回数据 */
    if(is_null($id)){
        return $list;
    } elseif(is_null($field)){
        return $list[$id];
    } else {
        return $list[$id][$field];
    }
}

/**
 * 解析UBB数据
 * @param string $data UBB字符串
 * @return string 解析为HTML的数据
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
function ubb($data){
    //TODO: 待完善，目前返回原始数据
    return $data;
}

/**
 * 记录行为日志，并执行该行为的规则
 * @param string $action 行为标识
 * @param string $model 触发行为的模型名
 * @param int $record_id 触发行为的记录id
 * @param int $user_id 执行行为的用户id
 * @return boolean
 * @author huajie <banhuajie@163.com>
 */
function action_log($action = null, $model = null, $record_id = null, $user_id = null){

    //参数检查
    if(empty($action) || empty($model) || empty($record_id)){
        return '参数不能为空';
    }
    if(empty($user_id)){
        $user_id = is_login();
    }

    //查询行为,判断是否执行
    $action_info = M('Action')->getByName($action);
    if($action_info['status'] != 1){
        return '该行为被禁用或删除';
    }

    //插入行为日志
    $data['action_id']      =   $action_info['id'];
    $data['user_id']        =   $user_id;
    $data['action_ip']      =   ip2long(get_client_ip());
    $data['model']          =   $model;
    $data['record_id']      =   $record_id;
    $data['create_time']    =   NOW_TIME;

    //解析日志规则,生成日志备注
    if(!empty($action_info['log'])){
        if(preg_match_all('/\[(\S+?)\]/', $action_info['log'], $match)){
            $log['user']    =   $user_id;
            $log['record']  =   $record_id;
            $log['model']   =   $model;
            $log['time']    =   NOW_TIME;
            $log['data']    =   array('user'=>$user_id,'model'=>$model,'record'=>$record_id,'time'=>NOW_TIME);
            foreach ($match[1] as $value){
                $param = explode('|', $value);
                if(isset($param[1])){
                    $replace[] = call_user_func($param[1],$log[$param[0]]);
                }else{
                    $replace[] = $log[$param[0]];
                }
            }
            $data['remark'] =   str_replace($match[0], $replace, $action_info['log']);
        }else{
            $data['remark'] =   $action_info['log'];
        }
    }else{
        //未定义日志规则，记录操作url
        $data['remark']     =   '操作url：'.$_SERVER['REQUEST_URI'];
    }

    M('ActionLog')->add($data);

    if(!empty($action_info['rule'])){
        //解析行为
        $rules = parse_action($action, $user_id);

        //执行行为
        $res = execute_action($rules, $action_info['id'], $user_id);
    }
}

/**
 * 解析行为规则
 * 规则定义  table:$table|field:$field|condition:$condition|rule:$rule[|cycle:$cycle|max:$max][;......]
 * 规则字段解释：table->要操作的数据表，不需要加表前缀；
 *              field->要操作的字段；
 *              condition->操作的条件，目前支持字符串，默认变量{$self}为执行行为的用户
 *              rule->对字段进行的具体操作，目前支持四则混合运算，如：1+score*2/2-3
 *              cycle->执行周期，单位（小时），表示$cycle小时内最多执行$max次
 *              max->单个周期内的最大执行次数（$cycle和$max必须同时定义，否则无效）
 * 单个行为后可加 ； 连接其他规则
 * @param string $action 行为id或者name
 * @param int $self 替换规则里的变量为执行用户的id
 * @return boolean|array: false解析出错 ， 成功返回规则数组
 * @author huajie <banhuajie@163.com>
 */
function parse_action($action = null, $self){
    if(empty($action)){
        return false;
    }

    //参数支持id或者name
    if(is_numeric($action)){
        $map = array('id'=>$action);
    }else{
        $map = array('name'=>$action);
    }

    //查询行为信息
    $info = M('Action')->where($map)->find();
    if(!$info || $info['status'] != 1){
        return false;
    }

    //解析规则:table:$table|field:$field|condition:$condition|rule:$rule[|cycle:$cycle|max:$max][;......]
    $rules = $info['rule'];
    $rules = str_replace('{$self}', $self, $rules);
    $rules = explode(';', $rules);
    $return = array();
    foreach ($rules as $key=>&$rule){
        $rule = explode('|', $rule);
        foreach ($rule as $k=>$fields){
            $field = empty($fields) ? array() : explode(':', $fields);
            if(!empty($field)){
                $return[$key][$field[0]] = $field[1];
            }
        }
        //cycle(检查周期)和max(周期内最大执行次数)必须同时存在，否则去掉这两个条件
        if(!array_key_exists('cycle', $return[$key]) || !array_key_exists('max', $return[$key])){
            unset($return[$key]['cycle'],$return[$key]['max']);
        }
    }

    return $return;
}

/**
 * 执行行为
 * @param array $rules 解析后的规则数组
 * @param int $action_id 行为id
 * @param array $user_id 执行的用户id
 * @return boolean false 失败 ， true 成功
 * @author huajie <banhuajie@163.com>
 */
function execute_action($rules = false, $action_id = null, $user_id = null){
    if(!$rules || empty($action_id) || empty($user_id)){
        return false;
    }

    $return = true;
    foreach ($rules as $rule){

        //检查执行周期
        $map = array('action_id'=>$action_id, 'user_id'=>$user_id);
        $map['create_time'] = array('gt', NOW_TIME - intval($rule['cycle']) * 3600);
        $exec_count = M('ActionLog')->where($map)->count();
        if($exec_count > $rule['max']){
            continue;
        }

        //执行数据库操作
        $Model = M(ucfirst($rule['table']));
        $field = $rule['field'];
        $res = $Model->where($rule['condition'])->setField($field, array('exp', $rule['rule']));

        if(!$res){
            $return = false;
        }
    }
    return $return;
}

//基于数组创建目录和文件
function create_dir_or_files($files){
    foreach ($files as $key => $value) {
        if(substr($value, -1) == '/'){
            mkdir($value);
        }else{
            @file_put_contents($value, '');
        }
    }
}

if(!function_exists('array_column')){
    function array_column(array $input, $columnKey, $indexKey = null) {
        $result = array();
        if (null === $indexKey) {
            if (null === $columnKey) {
                $result = array_values($input);
            } else {
                foreach ($input as $row) {
                    $result[] = $row[$columnKey];
                }
            }
        } else {
            if (null === $columnKey) {
                foreach ($input as $row) {
                    $result[$row[$indexKey]] = $row;
                }
            } else {
                foreach ($input as $row) {
                    $result[$row[$indexKey]] = $row[$columnKey];
                }
            }
        }
        return $result;
    }
}

/**
 * 获取表名（不含表前缀）
 * @param string $model_id
 * @return string 表名
 * @author huajie <banhuajie@163.com>
 */
function get_table_name($model_id = null){
    if(empty($model_id)){
        return false;
    }
    $Model = M('Model');
    $name = '';
    $info = $Model->getById($model_id);
    if($info['extend'] != 0){
        $name = $Model->getFieldById($info['extend'], 'name').'_';
    }
    $name .= $info['name'];
    return $name;
}

/**
 * 获取属性信息并缓存
 * @param  integer $id    属性ID
 * @param  string  $field 要获取的字段名
 * @return string         属性信息
 */
function get_model_attribute($model_id, $group = true,$fields=true){
    static $list;

    /* 非法ID */
    if(empty($model_id) || !is_numeric($model_id)){
        return '';
    }

    /* 获取属性 */
    if(!isset($list[$model_id])){
        $map = array('model_id'=>$model_id);
        $extend = M('Model')->getFieldById($model_id,'extend');

        if($extend){
            $map = array('model_id'=> array("in", array($model_id, $extend)));
        }
        $info = M('Attribute')->where($map)->field($fields)->select();
        $list[$model_id] = $info;
    }

    $attr = array();
    if($group){
        foreach ($list[$model_id] as $value) {
            $attr[$value['id']] = $value;
        }
        $model     = M("Model")->field("field_sort,attribute_list,attribute_alias")->find($model_id);
        $attribute = explode(",", $model['attribute_list']);
        if (empty($model['field_sort'])) { //未排序
            $group = array(1 => array_merge($attr));
        } else {
            $group = json_decode($model['field_sort'], true);

            $keys = array_keys($group);
            foreach ($group as &$value) {
                foreach ($value as $key => $val) {
                    $value[$key] = $attr[$val];
                    unset($attr[$val]);
                }
            }

            if (!empty($attr)) {
                foreach ($attr as $key => $val) {
                    if (!in_array($val['id'], $attribute)) {
                        unset($attr[$key]);
                    }
                }
                $group[$keys[0]] = array_merge($group[$keys[0]], $attr);
            }
        }
        if (!empty($model['attribute_alias'])) {
            $alias  = preg_split('/[;\r\n]+/s', $model['attribute_alias']);
            $fields = array();
            foreach ($alias as &$value) {
                $val             = explode(':', $value);
                $fields[$val[0]] = $val[1];
            }
            foreach ($group as &$value) {
                foreach ($value as $key => $val) {
                    if (!empty($fields[$val['name']])) {
                        $value[$key]['title'] = $fields[$val['name']];
                    }
                }
            }
        }
        $attr = $group;
    }else{
        foreach ($list[$model_id] as $value) {
            $attr[$value['name']] = $value;
        }
    }
    return $attr;
}

/**
 * 调用系统的API接口方法（静态方法）
 * api('User/getName','id=5'); 调用公共模块的User接口的getName方法
 * api('Admin/User/getName','id=5');  调用Admin模块的User接口
 * @param  string  $name 格式 [模块名]/接口名/方法名
 * @param  array|string  $vars 参数
 */
function api($name,$vars=array()){
    $array     = explode('/',$name);
    $method    = array_pop($array);
    $classname = array_pop($array);
    $module    = $array? array_pop($array) : 'Common';
    $callback  = $module.'\\Api\\'.$classname.'Api::'.$method;
    if(is_string($vars)) {
        parse_str($vars,$vars);
    }
    return call_user_func_array($callback,$vars);
}

/**
 * 根据条件字段获取指定表的数据
 * @param mixed $value 条件，可用常量或者数组
 * @param string $condition 条件字段
 * @param string $field 需要返回的字段，不传则返回整个数据
 * @param string $table 需要查询的表
 * @author huajie <banhuajie@163.com>
 */
function get_table_field($value = null, $condition = 'id', $field = null, $table = null){
    if(empty($value) || empty($table)){
        return false;
    }

    //拼接参数
    $map[$condition] = $value;
    $info = M(ucfirst($table))->where($map);
    if(empty($field)){
        $info = $info->field(true)->find();
    }else{
        $info = $info->getField($field);
    }
    return $info;
}

/**
 * 获取链接信息
 * @param int $link_id
 * @param string $field
 * @return 完整的链接信息或者某一字段
 * @author huajie <banhuajie@163.com>
 */
function get_link($link_id = null, $field = 'url'){
    $link = '';
    if(empty($link_id)){
        return $link;
    }
    $link = M('Url')->getById($link_id);
    if(empty($field)){
        return $link;
    }else{
        return $link[$field];
    }
}

/**
 * 获取文档封面图片
 * @param int $cover_id
 * @param string $field
 * @return 完整的数据  或者  指定的$field字段值
 * @author huajie <banhuajie@163.com>
 */
function get_cover_bak($cover_id, $field = null, $width=120, $height=120){
    if(empty($cover_id)){
        return false;
    }
    $picture = M('Picture')->where(array('status'=>1))->getById($cover_id);
    if($field == 'path'){
        if(!empty($picture['url'])){
            $picture['path'] = $picture['url'];
        }else{
            $picture['path'] = __ROOT__.$picture['path'];
        }
    }
    if ($field == 'html') {
        if(!empty($picture['url'])){
            $picture['path'] = $picture['url'];
        }else{
            $picture['path'] = __ROOT__.$picture['path'];
        }
        $html = "<img src='{$picture['path']}' style='width:".$width."px;height:".$height."px;'/>";
        return $html;
    }
    return empty($field) ? $picture : $picture[$field];
}

function get_imgUrl($path){

    if(empty($path)){
        return C('DefaultPic');
    }

    return $path;
}

function get_cover($cover_id, $path){

	if(empty($path)){
        return false;
    }

    $html = "<div  class='upload-pre-item upload_images' >"
            . "<div  class='upload_images_del' ids='".$cover_id."'>删除</div><img src='".$path."' class=''/></div>";
    return $html;

}


/**
 * 获取文档封面图片（多图）
 * @param string $img
 * @author tang
 */
function get_works_imgs($img,$path){

	if(empty($img)){
		return false;
	}
	$picture = M('Picture')->where(array('status'=>1))->select($img);
	$img_arr = explode(',', $img);
	$path_arr = explode(',', $path);
	foreach ($img_arr as $k=>$v){

		$path = __ROOT__.$v['path'];
		$html .=  '
				<div style="width:120px;height:170px;float:left;margin-left:5px;">
					<div class="upload-pre-item upload_images" >
						<div  class="works_images_del"  ids="'.$v.'">删除</div>
                    	<img src="'.$path_arr[$k].'" />
                   </div>
                </div>';
	}
	return $html;

}


/**
 * 获取数据的所有子孙数据的id值
 * @author 朱亚杰 <xcoolcc@gmail.com>
 */

function get_stemma($pids,Model &$model, $field='id'){
    $collection = array();

    //非空判断
    if(empty($pids)){
        return $collection;
    }

    if( is_array($pids) ){
        $pids = trim(implode(',',$pids),',');
    }
    $result     = $model->field($field)->where(array('pid'=>array('IN',(string)$pids)))->select();
    $child_ids  = array_column ((array)$result,'id');

    while( !empty($child_ids) ){
        $collection = array_merge($collection,$result);
        $result     = $model->field($field)->where( array( 'pid'=>array( 'IN', $child_ids ) ) )->select();
        $child_ids  = array_column((array)$result,'id');
    }
    return $collection;
}


/**
 * 系统非常规MD5加密方法
 * @param  string $str 要加密的字符串
 * @return string
 */
function pwd_md5($str, $key = 'ctrl_yun'){
    return empty($str)? '' : md5(sha1($str) . $key);
}


function print_pre($arr){
    echo '<pre>';
    print_r($arr);
}


function preview_url($id=0,$mid=0){
	$url = U('Index/view',array('id'=>$id,'mid'=>$mid),'',true);
	$url = str_replace('web.php', 'index.php', $url);
	$url = str_replace('m.php', 'index.php', $url);
	return $url;
}

function route_merchant_url($mid=0){
	$url = U('Merchant/Public/route',array('mid'=>$mid,'token'=>think_encrypt(date('Y-m-d'))),'',true);
	$url = str_replace('m.php', 'index.php', $url);
	return $url;
}


function route_agent_url($mid=0){
    $url = U('Agent/Public/route',array('mid'=>$mid,'token'=>think_encrypt(date('Y-m-d'))),'',true);
    $url = str_replace('m.php', 'index.php', $url);
    return $url;
}


function route_factory_url($mid=0){
    $url = U('Factory/Public/route',array('mid'=>$mid,'token'=>think_encrypt(date('Y-m-d'))),'',true);
    $url = str_replace('m.php', 'index.php', $url);
    return $url;
}


function getBoxType($index=0){
	$types = array(
			1=>'hanging cabinet',
			2=>'square cabinet',
			3=>'shoe cabinet'
	);
	if(empty($index))
		return $types;
	else
		return $types[$index];
}

//查询柜机格子使用情况
function getBoxUsed($mac_id=0){
    $map['status'] = 1;
    $map['mac_id'] = $mac_id;
    $total = M('MachineBox')->where($map)->count();
    $map['is_used'] = 1;
    $used = M('MachineBox')->where($map)->count();

    return $used.'/'.$total;

}

/**
 * 获取分类信息并缓存分类
 * @param  integer $id    分类ID
 * @param  string  $field 要获取的字段名
 * @return string         分类信息
 */
function get_category($id, $field = null){
	static $list;

	/* 非法分类ID */
	if(empty($id) || !is_numeric($id)){
		return '';
	}

	/* 读取缓存数据 */
	if(empty($list)){
		$list = S('sys_category_list');
	}

	/* 获取分类名称 */
	if(!isset($list[$id])){
		$cate = M('Category')->find($id);
		if(!$cate || 1 != $cate['status']){ //不存在分类，或分类被禁用
			return '';
		}
		$list[$id] = $cate;
		S('sys_category_list', $list); //更新缓存
	}
	return is_null($field) ? $list[$id] : $list[$id][$field];
}


/* 根据ID获取分类名称 */
function get_category_title($id){
	return get_category($id, 'title');
}

//生成订单号
function make_orderSn($uid=''){
	return 'sn_'.rand(10, 99).time();
// 	return 'sn_'.$uid.time().rand(10000, 99999);
}

//生成取件码
function make_fetchCode($mac_id=''){
	$code = rand(100000, 999999);
	$map['status'] = 0;
	$map['code'] = $code;
	$row = M('order_code')->where($map)->find();
	if($row){
		return make_fetchCode();
	}else
		return $code;
// 	return substr(md5(microtime(true)), 0, 6);
}

//生成预约码
function make_yuyueCode($mac_id=''){
	$code = rand(100000, 999999);
	$map['yuyue'] = 1;
	$map['yuyue_code'] = $code;
	$row = M('order')->where($map)->find();
	if($row){
		return make_yuyueCode();
	}else
		return $code;
	// 	return substr(md5(microtime(true)), 0, 6);
}

function getBox_for_member(){
	return 1;
}

function getBox_for_merchant(){
	return 1;
}


//获取当前订单可用格子
function getAvlBox($out_trade_no, $type='merchant'){

	$orderInfo = M('Order')->where(array('out_trade_no'=>$out_trade_no))->find();
	if(!empty($orderInfo['box'])){
		return $orderInfo['box'];
	}

	$map['status'] = 1;
	$map['mac_id'] = $orderInfo['mac_id'];
	$map['is_used'] = 0;

    //@file_put_contents(dirname(__FILE__) . '/a.txt', "map: " . json_encode($map) . PHP_EOL, FILE_APPEND);

	$boxes = M('MachineBox')->where($map)->select();
    //@file_put_contents(dirname(__FILE__) . '/a.txt', "boxes: " . json_encode($boxes) . PHP_EOL, FILE_APPEND);
	if(empty($boxes))
		return '';
	else{
		$goodsList = json_decode($orderInfo['body'], true);
		$clothes_box = 0;
		$shoe_box = 0;
		$box = '';
		foreach ($goodsList as $g){
			$cate = M('Category')->find($g['cate']);
			if($cate['type']==1 && !strstr($g['title'], '包')) //鞋包分类下，且不是包
				$shoe_box=1;
			else
				$clothes_box=1;
		}

		if($clothes_box){//需要衣服柜
			$map['type'] = array('lt',3);
			if($type=='member')
				$order = 'type desc,num asc';
			else
				$order = 'type asc,num asc';
			$row = M('MachineBox')->where($map)->order($order)->find();
            //@file_put_contents(dirname(__FILE__) . '/a.txt', "clothes_box MachineBox: " . json_encode($row) . PHP_EOL, FILE_APPEND);
			if(empty($row))
				return '';
			else{
				$box = $row['num'];
			}
            //@file_put_contents(dirname(__FILE__) . '/a.txt', "clothes_box BOX: " . $box, FILE_APPEND);
		}
		if($shoe_box){//需要鞋柜
			$map['type'] = 3;
			$row = M('MachineBox')->where($map)->order('num asc')->find();
            @file_put_contents(dirname(__FILE__) . '/a.txt', "shoe_box MachineBox: " . json_encode($row). PHP_EOL, FILE_APPEND);
			if(empty($row)){
				if(empty($box))
					return '';
			}else{
				$box = empty($box)? $row['num']:($box.','.$row['num']);
			}
            //@file_put_contents(dirname(__FILE__) . '/a.txt', "shoe_box BOX: " . $box. PHP_EOL, FILE_APPEND);
		}

		if(!empty($box)){
			$data['box'] = $box;
			$res = M('Order')->where(array('out_trade_no'=>$out_trade_no))->save($data);

			$where['mac_id'] = $orderInfo['mac_id'];
			$where['num'] = array('in',$box);
			M('MachineBox')->where($where)->save(array('is_used'=>1));

// 			$insert = array(
// 					'out_trade_no' =>$out_trade_no,
// 					'mac_id' =>$orderInfo['mac_id'],
// 					'mid' => $orderInfo['mid'],
// 					'userid' =>$orderInfo['userid'],
// 					'box' => $box,
// 					'createtime' =>time()
// 			);
// 			if($type=='member'){
// 				M('MemberLog')->add($insert);
// 			}else{
// 				M('MerchantLog')->add($insert);
// 			}
		}

		return $box;
	}
}

/**
 * 支付完成修改订单
 * $out_trade_no 订单号
 */
function update_pay_success($out_trade_no, $trade_no)
{
	$map['out_trade_no'] = $out_trade_no;

	// 找出对应的订单
	if(substr($out_trade_no, 0,1)=='f'){ //订单需要额外支付
		$obj_order = M('OrderCode');
	}else if(substr($out_trade_no, 0,1)=='c'){ //用户充值
		$obj_order = M('OrderCharge');
	}else{ //普通订单
		$obj_order = M('Order');
	}

	$order = $obj_order->where($map)->find();
	if($order['pay_status']==1)
		return ;

	$data = array('pay_status'=>1,'pay_time'=>time(),'trade_no'=>$trade_no);

	// 修改支付状态  已支付
	$obj_order->where($map)->save($data);

	if($order['yuyue']){
		$yuyueCode = make_yuyueCode();


		//发送预约码
		$params['code'] = $yuyueCode;
		$obj_sms = new Sms();
		$status = $obj_sms->send($order['mobile'], 'yuyue_code', $params);

		$data2['yuyue_code'] = $yuyueCode;
		// 写入预约码
		$obj_order->where($map)->save($data2);

		write_order_log($out_trade_no,'booking success，use box'.$order['box'].'，send code：'.$yuyueCode);

	}




	// 给他升级, 根据order表查看消费记录 给他会员等级升级 修改他的折扣 和 总金额
// 	update_user_level($order['user_id']);
	// 记录订单操作日志
// 	logOrder($order['order_id'],'订单付款成功','付款成功',$order['user_id']);

}


/**
 * 支付完成修改订单
 * $out_trade_no 订单号
 */
function update_pay_type($out_trade_no, $pay_type)
{
	$map['out_trade_no'] = $out_trade_no;

	// 找出对应的订单
	if(substr($out_trade_no, 0,1)=='f'){
		$obj_order = M('OrderCode');
	}else if(substr($out_trade_no, 0,1)=='c'){ //用户充值
		$obj_order = M('OrderCharge');
	}else{
		$obj_order = M('Order');
	}

	// 修改支付状态  已支付
	$obj_order->where($map)->save(array('pay_type'=>$pay_type));

}


/**
 * 写入订单日志
 * $out_trade_no 订单号
 */
function write_order_log($out_trade_no, $content)
{

    $insert = array(
			'out_trade_no' =>$out_trade_no,
			'content' => $content,
			'createtime' =>time()
	);
	M('OrderLog')->add($insert);
}


/**
 * 检查是否爆仓
 * $out_trade_no 订单号
 */
function check_baocang($out_trade_no)
{
	return;
    $map['out_trade_no'] = $out_trade_no;

    // 找出对应的订单
    if(substr($out_trade_no, 0,1)=='f'){
        return;
    }else{
        $obj_order = M('Order');
        $orderInfo = $obj_order->where($map)->find();
        if(!$orderInfo)
            return ;

        $is_full = 0;
        $box['status'] = 1;
        $box['mac_id'] = $orderInfo['mac_id'];
        $box['is_used'] = 0;
        $box['type'] = 2;
        $num = M('machine_box')->where($box)->count();
        if($num<=2)
            $is_full =1;

        $box['type'] = 3;
        $num = M('machine_box')->where($box)->count();
        if($num<=2)
            $is_full =1;

        $macInfo = M('machine')->find($orderInfo['mac_id']);

        if($is_full){
            //发送短信，提醒管理员爆仓
            $params['num'] = $orderInfo['mac_id'];
            $obj_sms = new Sms();
            $status = $obj_sms->send($macInfo['mobile'], 'machine_full', $params);
        }

    }

}

//给用户充值
function member_charge($out_trade_no){
    $map = array(
        'out_trade_no'=>$out_trade_no,
        'pay_status'=>1,
        'status'=>1
    );
    $chargeLog = M('OrderCharge')->where($map)->find();
    if($chargeLog){
        $obj_mem = new MemberModel();
        $uid = $chargeLog['userid'];
        $obj_mem->updateAmount($uid, $chargeLog['pay_fee']);
        M('OrderCharge')->where($map)->save(array('status'=>0)); //防止二次充值

        //保存充值记录
        $charge['userid'] = $uid;
        $charge['out_trade_no'] = $out_trade_no;
        $charge['pay_fee'] = $chargeLog['pay_fee'];
        $charge['create_time'] = time();
        M('LogCharge')->add($charge);
        
        if($chargeLog['source'] == 'admin'){//管理员充值，不赠送
            return true;
        }
        

        $memInfo = $obj_mem->getInfoById($uid);
        $level = 0;
        
        //检查充值规则，是否需要赠送
        $map['status'] = 1;
        $map['pay_fee'] = $chargeLog['pay_fee'];
        $rule = M('ChargeRule')->where($map)->find();
        if($rule && $rule['gift_fee']>0){
            $obj_mem->updateAmount($uid, $rule['gift_fee']);
            //保存充值记录
            $charge2['userid'] = $uid;
            $charge2['out_trade_no'] = $out_trade_no;
            $charge2['gift_fee'] = $rule['gift_fee'];
            $charge2['note'] = $rule['title'];
            $charge2['create_time'] = time();
            M('LogCharge')->add($charge2);
        }
        return true;

    }
    return false;

}

//赠送优惠券
function sendCoupon($uid){
	//$month = strtotime("+$months month");

    $obj_coupon = new MemberCouponModel();
//     $obj_coupon->createCoupon(30,$uid, '15元代金券（满40可用）', 15, 40, 1);
//     $obj_coupon->createCoupon(30,$uid, '30元代金券（满70可用）', 30, 70, 1);
    $obj_coupon->createCoupon(31,$uid, '新人免洗一件', 19.9, 19.9, '2018-10-30',717);
    $obj_coupon->createCoupon(31,$uid, '5元代金券', 5, 0, '2018-10-30');
    $obj_coupon->createCoupon(31,$uid, '5元代金券', 5, 0, '2018-10-30');


}


/**
 * 格式化参数格式化成url参数
 */
function ToUrlParams($values)
{
	$buff = "";
	foreach ($values as $k => $v)
	{
		$buff .= $k . "=" . trim($v). "&";
	}

	$buff = trim($buff, "&");
	return $buff;
}


function httpGet($url) {
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_TIMEOUT, 500);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($curl, CURLOPT_URL, $url);

	$res = curl_exec($curl);
	curl_close($curl);
	return $res;
}


function httpPost($url,$data){ // 模拟提交数据函数
	$curl = curl_init(); // 启动一个CURL会话
	curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0); // 对认证证书来源的检查
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 1); // 从证书中检查SSL加密算法是否存在
	curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览器
	curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); // 使用自动跳转
	curl_setopt($curl, CURLOPT_AUTOREFERER, 1); // 自动设置Referer
	curl_setopt($curl, CURLOPT_POST, 1); // 发送一个常规的Post请求
	curl_setopt($curl, CURLOPT_POSTFIELDS, $data); // Post提交的数据包
	curl_setopt($curl, CURLOPT_COOKIEFILE, $GLOBALS['cookie_file']); // 读取上面所储存的Cookie信息
	curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循环
	curl_setopt($curl, CURLOPT_HEADER, 0); // 显示返回的Header区域内容
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); // 获取的信息以文件流的形式返回
	$tmpInfo = curl_exec($curl); // 执行操作
	if (curl_errno($curl)) {
		echo 'Errno'.curl_error($curl);
	}
	curl_close($curl); // 关键CURL会话
	return $tmpInfo; // 返回数据
}


function getOrderStatus($st,$pay_status=0,$yuyue=0,$source='weixin'){
    if($pay_status){
        if($yuyue==1 && $st!=10){
            return 'booking';
        }else{
            if($st==1){
                return 'wait courier to fetch';
            }elseif($st==2){
                return 'fetched by courier';
            }elseif($st==3){
                return 'wait customer to fetch';
            }elseif($st==10){
                return 'finished';
            }
        }
    }else{
        return 'unpaid';
    }
}


function get_order_plus_pay_status($order_sn=''){
    if(!$order_sn){
        return 'unpaid';
    }
    $map['order_sn'] = $order_sn;
    $info = M('OrderCode')->where($map)->find();
    if($info && $info['pay_status']){
        return 'paid';
    }else{
        return 'unpaid';
    }

}


function get_order_source($source=''){
	switch ($source){
		case 'machine':
			return 'machine';
			break;
		case 'weixin':
			return 'wechat';
			break;
		case 'alipay':
			return 'alipay';
			break;
		case 'line':
		    return 'line';
		    break;
		default:
			return 'machine';
			break;
	}
}

function getMachineStatus($uuid){
	$key = $uuid.'_active_time';
	if(S($key)){
		$act_time = S($key);
		if(time()-$act_time>120)
			return 0;
		else
			return 1;
	}
	return 0;

}


//设置商户id有新订单
function setNewOrder($mid){
	$key = $mid.'_new_order';
	S($key,1);
}

//根据商户id检查是否有新订单
function hasNewOrder($mid){
	$key = $mid.'_new_order';
	if(S($key)){
		$value = S($key);
		if($value==1){
			S($key,null);
			echo 1;
			exit;
		}else{
			echo 0;
			exit;
		}
	}
	echo 0;
}


//设置扫码登录用户
function setScanLogin($ukey,$userInfo){
    $key = $ukey.'_scan_login';
    S($key,$userInfo);
}

//根据uuid检查用户是否确登录
function getScanLogin($ukey){
    $userInfo = array();
    $key = $ukey.'_scan_login';
    if(S($key)){
        $userInfo = S($key);
//         S($key,null);
    }
    return  $userInfo;
}


//设置扫码取件
function setScanFetch($ukey,$code_arr){
    $key = $ukey.'_scan_fetch';
    S($key,$code_arr);
}

//根据uuid检查用户扫码取件获得的取件码
function getScanFetch($ukey){
    $code_arr = array();
    $key = $ukey.'_scan_fetch';
    if(S($key)){
        $code_arr = S($key);
        S($key,null);
    }
    return  $code_arr;
}



/**
 * 获取柜机信息
 * @param  integer $id    分类ID
 * @param  string  $field 要获取的字段名
 * @return string         分类信息
 */
function get_machine($id, $field = null){
    static $list;

    /* 非法分类ID */
    if(empty($id) || !is_numeric($id)){
        return '';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('sys_machine_list');
    }

    /* 获取分类名称 */
    if(!isset($list[$id])){
        $info = M('Machine')->find($id);
        if(!$info){
            return '';
        }
        $list[$id] = $info;
        S('sys_machine_list', $list); //更新缓存
    }
    return is_null($field) ? $list[$id] : $list[$id][$field];
}

/**
 * 获取代理信息
 * @param  integer $id    分类ID
 * @param  string  $field 要获取的字段名
 * @return string         分类信息
 */
function get_agent($id, $field = null){
    static $list;

    /* 非法分类ID */
    if(empty($id) || !is_numeric($id)){
        return 'admin';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('sys_agent_list');
    }

    /* 获取分类名称 */
    if(!isset($list[$id])){
        $info = M('Agent')->find($id);
        if(!$info){
            return '';
        }
        $list[$id] = $info;
        S('sys_agent_list', $list); //更新缓存
    }
    return is_null($field) ? $list[$id] : $list[$id][$field];
}

/**
 * 获取加盟商信息
 * @param  integer $id    分类ID
 * @param  string  $field 要获取的字段名
 * @return string         分类信息
 */
function get_merchant($id, $field = null){
    static $list;

    /* 非法分类ID */
    if(empty($id) || !is_numeric($id)){
        return 'self-support'; //自营
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('sys_merchant_list');
    }

    /* 获取分类名称 */
    if(!isset($list[$id])){
        $info = M('Merchant')->find($id);
        if(!$info){
            return '';
        }
        $list[$id] = $info;
        S('sys_merchant_list', $list); //更新缓存
    }
    return is_null($field) ? $list[$id] : $list[$id][$field];
}

/**
 * 获取洗衣厂信息
 * @param  integer $id    分类ID
 * @param  string  $field 要获取的字段名
 * @return string         分类信息
 */
function get_factory($id, $field = null){
    static $list;

    /* 非法分类ID */
    if(empty($id) || !is_numeric($id)){
        return '';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('sys_factory_list');
    }

    /* 获取分类名称 */
    if(!isset($list[$id])){
        $info = M('Factory')->find($id);
        if(!$info){
            return '';
        }
        $list[$id] = $info;
        S('sys_factory_list', $list); //更新缓存
    }
    return is_null($field) ? $list[$id] : $list[$id][$field];
}

//计算客户下单次数
function get_buy_times($uid){
    $map['userid'] = $uid;
    $map['pay_status'] = 1;
    $num = M('Order')->where($map)->count();
    return $num;
}

//会员折扣
function get_level_title($level=0){
    switch ($level){
        case 0:
            return 'general';
            break;
        case 1:
            return 'one star';
            break;
        case 2:
            return 'two-star';
            break;
        case 3:
            return 'three-star';
            break;
        case 4:
            return 'four-star';
            break;
        case 5:
            return 'five-star';
            break;
        default:
            return 'general';
            break;
    }

}

//会员折扣
function get_level_rate($level=0){
    switch ($level){
        case 0:
            return 1;
            break;
        case 1:
            return 0.98;
            break;
        case 2:
            return 0.88;
            break;
        case 3:
            return 0.78;
            break;
        case 4:
            return 0.78;
            break;
        case 5:
            return 0.78;
            break;
        default:
            return 1;
            break;
    }
}

//会员折扣
function get_level_rate_title($level=0){
    switch ($level){
        case 0:
            return '全款';
            break;
        case 1:
            return '98折';
            break;
        case 2:
            return '88折';
            break;
        case 3:
            return '78折';
            break;
        case 4:
            return '78折';
            break;
        case 5:
            return '78折';
            break;
        default:
            return '全款';
            break;
    }
}

//会员价
function get_level_price($level,$total){
	$price = get_level_rate($level)*$total;
	$price = round($price,2);
	return $price;

}

//会员价
function get_level_discount($level,$total){
	$price = get_level_rate($level)*$total;
	$price = round($price,2);

	return $total-$price;

}

//获取支付方式
function get_payment_title($type){
    if($type=='wxpay')
        return 'wechat pay';
    elseif($type=='alipay')
        return 'alipay';
    elseif($type=='line')
        return 'Linepay';
    elseif($type=='admin')
        return 'admin';
    else
        return '';
}


//获取支付来源
function get_payment_source($type){
    if($type=='admin')
        return 'admin';
    else
        return 'machine';
}


//清除缓存
function clearCache(){
	S('sys_category_list',null);
	S('sys_agent_list',null);
	S('sys_merchant_list',null);
	S('sys_factory_list',null);
	S('sys_machine_list',null);
	S('sys_member_list',null);
	S('sys_user_nickname_list',null);
}


//控制台中输出信息
function cmd_msg($msg){
    //$msg = iconv('UTF-8','GBK', $msg);
    echo $msg;
}

//控制台中显示等待
function show_wating($num){
    for($i=0; $i<$num; $i++){
        echo '>>';
        sleep(1);

    }
    echo "\n";
}


//写日志
function write_log($logfile, $msg){
    $msg = '['.date('Y-m-d H:i:s').'] '.$msg."\r\n";
    file_put_contents($logfile, $msg, FILE_APPEND);
}

//输入提示信息
function show_msg($msg){
    header("Content-type:text/html;charset=utf-8");
    exit("<h1>".$msg."</h1>");
}

