<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Model;
use Think\Model;

/**
 * 管理员模型
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */

class ManagerModel extends Model {

    protected $_validate = array(
        array('username', '1,16', 'username length is 1-16', self::EXISTS_VALIDATE, 'length'),
        array('username', '', 'username occupied', self::EXISTS_VALIDATE, 'unique'), //用户名被占用
        array('password', 'require', 'password can not be empty', self::MUST_VALIDATE , 'regex', self::MODEL_INSERT),
    );

    /* 自动完成规则 */
    protected $_auto = array(
            array('password', 'pwd_md5', self::MODEL_BOTH, 'function', AUTH_KEY),
            array('password','',2,'ignore'),
            array('reg_time', NOW_TIME, self::MODEL_INSERT),
            array('reg_ip', 'get_client_ip', self::MODEL_INSERT, 'function', 1),
            array('update_time', NOW_TIME, self::MODEL_BOTH),
            array('status', 'getStatus', self::MODEL_BOTH, 'callback'),
            array('nickname', 'setNickName', self::MODEL_BOTH, 'callback'),
    );

    /**
     * 根据配置指定用户状态
     * @return integer 用户状态
     */
    protected function getStatus(){
        return true; //TODO: 暂不限制，下一个版本完善
    }

    /**
     * 默认用户昵称
     * @return integer 用户状态
     */
    protected function setNickName(){
        return I('username');
    }


    public function lists($status = 1, $order = 'uid DESC', $field = true){
        $map = array('status' => $status);
        return $this->field($field)->where($map)->order($order)->select();
    }

    /**
     * 登录指定用户
     * @param  integer $uid 用户ID
     * @return boolean      ture-登录成功，false-登录失败
     */
    public function login($username='',$password=''){
        $info = M('Manager')->where(array('username'=>$username))->find();
        if ($info) {
            $pass = $info['password'];
            if (pwd_md5($password, AUTH_KEY) != $pass) {
                $return['msg'] = 'password is incorrect';
            }else{
                if($info['status']!=1){
                    $return['msg'] = 'The account has been disabled';
                }
                $return['id'] = $info['uid'];
            }
        }else{
            $return['msg'] = 'username is incorrect';
        }

        //记录行为
        action_log('user_login', 'manager', $info['id'], $info['id']);
        /* 登录用户 */
        $this->autoLogin($info);
        return $return;
    }

    /**
     * 注销当前用户
     * @return void
     */
    public function logout(){
        session('manager_auth', null);
        session('manager_auth_sign', null);
    }

    /**
     * 自动登录用户
     * @param  integer $user 用户信息数组
     */
    private function autoLogin($user){
        /* 更新登录信息 */
        $data = array(
            'uid'             => $user['uid'],
            'login'           => array('exp', '`login`+1'),
            'last_login_time' => NOW_TIME,
            'last_login_ip'   => get_client_ip(1),
        );
        $this->save($data);

        /* 记录登录SESSION和COOKIES */
        $auth = array(
            'uid'             => $user['uid'],
            'username'        => $user['username'],
            'last_login_time' => $user['last_login_time'],
        );

        session('manager_auth', $auth);
        session('manager_auth_sign', data_auth_sign($auth));

    }

    public function getNickName($uid){
        return $this->where(array('uid'=>(int)$uid))->getField('nickname');
    }

    public function getUserInfo($uid){
        return $this->where(array('uid'=>(int)$uid))->find();
    }

}
