<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
namespace Agent\Controller;
use Think\Controller;
use Admin\Model\ConfigModel;
/**
 * 后台首页控制器
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
class AdminController extends Controller {

    /**
     * 后台控制器初始化
     */
    protected function _initialize(){
        // 获取当前用户ID
        if(defined('UID')) return ;
        define('UID',is_login());
        if( !UID ){// 还没登录 跳转到登录页面
            $this->redirect('Public/login');
        }
        /* 读取数据库中的配置 */
        $config =   S('DB_CONFIG_DATA');
        if(!$config){
        	$obj_config = new ConfigModel();
        	$config   = $obj_config->detail();
            S('DB_CONFIG_DATA',$config);
        }
        C($config); //添加配置

    }


    /**
     * 对数据表中的单行或多行记录执行修改 GET参数id为数字或逗号分隔的数字
     *
     * @param string $model 模型名称,供M函数使用的参数
     * @param array  $data  修改的数据
     * @param array  $where 查询时的where()方法的参数
     * @param array  $msg   执行正确和错误的消息 array('success'=>'','error'=>'', 'url'=>'','ajax'=>false)
     *                     url为跳转页面,ajax是否ajax方式(数字则为倒数计时秒数)
     *
     * @author 朱亚杰  <zhuyajie@topthink.net>
     */
    final protected function editRow ( $model ,$data, $where , $msg ){
        $id    = array_unique((array)I('id',0));
        $id    = is_array($id) ? implode(',',$id) : $id;
        //如存在id字段，则加入该条件
        $fields = M($model)->getDbFields();
        if(in_array('id',$fields) && !empty($id)){
            $where = array_merge( array('id' => array('in', $id )) ,(array)$where );
        }

        $msg   = array_merge( array( 'success'=>'Operation succeeded！', 'error'=>'Operation failed！', 'url'=>'' ,'ajax'=>IS_AJAX) , (array)$msg );
        if( M($model)->where($where)->save($data)!==false ) {
            $this->success($msg['success'],$msg['url'],$msg['ajax']);
        }else{
            $this->error($msg['error'],$msg['url'],$msg['ajax']);
        }
    }

    /**
     * 禁用条目
     * @param string $model 模型名称,供D函数使用的参数
     * @param array  $where 查询时的 where()方法的参数
     * @param array  $msg   执行正确和错误的消息,可以设置四个元素 array('success'=>'','error'=>'', 'url'=>'','ajax'=>false)
     *                     url为跳转页面,ajax是否ajax方式(数字则为倒数计时秒数)
     *
     * @author 朱亚杰  <zhuyajie@topthink.net>
     */
    protected function forbid ( $model , $where = array() , $msg = array( 'success'=>'状态禁用成功！', 'error'=>'状态禁用失败！')){
        $data    =  array('status' => 0);
        $this->editRow( $model , $data, $where, $msg);
    }

    /**
     * 恢复条目
     * @param string $model 模型名称,供D函数使用的参数
     * @param array  $where 查询时的where()方法的参数
     * @param array  $msg   执行正确和错误的消息 array('success'=>'','error'=>'', 'url'=>'','ajax'=>false)
     *                     url为跳转页面,ajax是否ajax方式(数字则为倒数计时秒数)
     *
     * @author 朱亚杰  <zhuyajie@topthink.net>
     */
    protected function resume (  $model , $where = array() , $msg = array( 'success'=>'状态恢复成功！', 'error'=>'状态恢复失败！')){
        $data    =  array('status' => 1);
        $this->editRow(   $model , $data, $where, $msg);
    }

    /**
     * 还原条目
     * @param string $model 模型名称,供D函数使用的参数
     * @param array  $where 查询时的where()方法的参数
     * @param array  $msg   执行正确和错误的消息 array('success'=>'','error'=>'', 'url'=>'','ajax'=>false)
     *                     url为跳转页面,ajax是否ajax方式(数字则为倒数计时秒数)
     * @author huajie  <banhuajie@163.com>
     */
    protected function restore (  $model , $where = array() , $msg = array( 'success'=>'状态还原成功！', 'error'=>'状态还原失败！')){
        $data    = array('status' => 1);
        $where   = array_merge(array('status' => -1),$where);
        $this->editRow(   $model , $data, $where, $msg);
    }

    /**
     * 条目假删除
     * @param string $model 模型名称,供D函数使用的参数
     * @param array  $where 查询时的where()方法的参数
     * @param array  $msg   执行正确和错误的消息 array('success'=>'','error'=>'', 'url'=>'','ajax'=>false)
     *                     url为跳转页面,ajax是否ajax方式(数字则为倒数计时秒数)
     *
     * @author 朱亚杰  <zhuyajie@topthink.net>
     */
    protected function delete ( $model , $where = array() , $msg = array( 'success'=>'删除成功！', 'error'=>'删除失败！')) {
        $data['status']         =   -1;
        $this->editRow(   $model , $data, $where, $msg);
    }

    /**
     * 设置一条或者多条数据的状态
     */
    public function setStatus($Model=CONTROLLER_NAME){

        $ids    =   I('request.ids');
        $status =   I('request.status');
        if(empty($ids)){
            $this->error('Please select the data to operate on');
        }

        $map['id'] = array('in',$ids);
        switch ($status){
            case -1 :
                $this->delete($Model, $map, array('success'=>'Delete success','error'=>'Delete failure'));
                break;
            case 0  :
                $this->forbid($Model, $map, array('success'=>'Status Disabled Successfully','error'=>'State disabled failure'));
                break;
            case 1  :
                $this->resume($Model, $map, array('success'=>'State recovery success','error'=>'State recovery failure'));
                break;
            default :
                $this->error('Parameter error');
                break;
        }
    }



    /**
     * 通用分页列表数据集获取方法
     *
     *  可以通过url参数传递where条件,例如:  index.html?name=asdfasdfasdfddds
     *  可以通过url空值排序字段和方式,例如: index.html?_field=id&_order=asc
     *  可以通过url参数r指定每页数据条数,例如: index.html?r=5
     *
     * @param sting|Model  $model   模型名或模型实例
     * @param array        $where   where查询条件(优先级: $where>$_REQUEST>模型设定)
     * @param array|string $order   排序条件,传入null时使用sql默认排序或模型属性(优先级最高);
     *                              请求参数中如果指定了_order和_field则据此排序(优先级第二);
     *                              否则使用$order参数(如果$order参数,且模型也没有设定过order,则取主键降序);
     *
     * @param boolean      $field   单表模型用不到该参数,要用在多表join时为field()方法指定参数
     * @author 朱亚杰 <xcoolcc@gmail.com>
     *
     * @return array|false
     * 返回数据集
     */
    protected function lists ($model,$where=array(),$order='',$field=true){
        $options    =   array();
        $REQUEST    =   (array)I('request.');
        if(is_string($model)){
            $model  =   M($model);
        }

        $OPT        =   new \ReflectionProperty($model,'options');
        $OPT->setAccessible(true);

        $pk         =   $model->getPk();
        if($order===null){
            //order置空
        }else if ( isset($REQUEST['_order']) && isset($REQUEST['_field']) && in_array(strtolower($REQUEST['_order']),array('desc','asc')) ) {
            $options['order'] = '`'.$REQUEST['_field'].'` '.$REQUEST['_order'];
        }elseif( $order==='' && empty($options['order']) && !empty($pk) ){
            $options['order'] = $pk.' desc';
        }elseif($order){
            $options['order'] = $order;
        }
        unset($REQUEST['_order'],$REQUEST['_field']);

        if(empty($where)){
            $where  =   array('status'=>array('egt',0));
        }
        if( !empty($where)){
            $options['where']   =   $where;
        }
        $options      =   array_merge( (array)$OPT->getValue($model), $options );
        $total        =   $model->where($options['where'])->count();

        if( isset($REQUEST['r']) ){
            $listRows = (int)$REQUEST['r'];
        }else{
            $listRows = C('LIST_ROWS') > 0 ? C('LIST_ROWS') : 10;
        }
        $page = new \Think\Page($total, $listRows, $REQUEST);
        if($total>$listRows){
            $page->setConfig('theme','%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%');
        }
        $p =$page->show();
        $this->assign('_page', $p? $p: '');
        $this->assign('_total',$total);
        $options['limit'] = $page->firstRow.','.$page->listRows;

        $model->setProperty('options',$options);

        return $model->field($field)->select();
    }

    /**
     * 处理文档列表显示
     * @param array $list 列表数据
     * @param integer $model_id 模型id
     */
    protected function parseDocumentList($list,$model_id=null){
        $model_id = $model_id ? $model_id : 1;
        $attrList = get_model_attribute($model_id,false,'id,name,type,extra');
        // 对列表数据进行显示处理
        if(is_array($list)){
            foreach ($list as $k=>$data){
                foreach($data as $key=>$val){
                    if(isset($attrList[$key])){
                        $extra      =   $attrList[$key]['extra'];
                        $type       =   $attrList[$key]['type'];
                        if('select'== $type || 'checkbox' == $type || 'radio' == $type || 'bool' == $type) {
                            // 枚举/多选/单选/布尔型
                            $options    =   parse_field_attr($extra);
                            if($options && array_key_exists($val,$options)) {
                                $data[$key]    =   $options[$val];
                            }
                        }elseif('date'==$type){ // 日期型
                            $data[$key]    =   date('Y-m-d',$val);
                        }elseif('datetime' == $type){ // 时间型
                            $data[$key]    =   date('Y-m-d H:i',$val);
                        }
                    }
                }
                $data['model_id'] = $model_id;
                $list[$k]   =   $data;
            }
        }
        return $list;
    }


    // 设置字段值
    function setField(){
        $id = I('get.id',0) > 0 ? I('get.id') : I('ids');
        $model = I('get.model',CONTROLLER_NAME);
        $field = I('get.field','status');
        $value = I('get.val',0);
        $data[$field] = $value;
        $model = M($model);
        $map['id'] = array('in',$id);
        if($model->where($map)->save($data)){
            $this->success('Operation succeeded',U('index'));
        }else{
            $this->error('Server error');
        }

    }
    /**
     * 公用的保存功能
     * @param string $obj 实例化对象名称
     * @author tang
     * @return array
     */
    function _save($obj = CONTROLLER_NAME){
        $model = D($obj);
        $status = 0;
        if($model->create()){
            if($model->id){
                $status = $model->save();
            }else{
                $status = $model->add();
            }
            if($status){
                $message = 'Operation succeeded';
            }else{
                $message = "Sorry, you haven't made any changes";
            }
        }else{
            $message = $model->getError();
        }
        return array('status'=>$status,'message'=>$message);
    }
    /**
     * 公用的删除功能
     * @param string $obj 实例化对象名称
     * @param array $map 删除条件
     * @author tang
     * @return array
     */
    function _delete($obj = CONTROLLER_NAME, $map = array()){
        $status = 0;
        $model = M($obj);
        if($map){
            $status = $model->where($map)->delete();
        }else{
            $id = I('get.id',0) > 0 ? I('get.id') : I('ids');
            $status = $model->delete($id);
        }
        if($status){
            $message = 'Delete success';
        }else{
            $message =  'Delete failure';
        }
        return array('status'=>$status,'message'=>$message);
    }
    /**
     * 保存跳转
     * @param string $url 跳转页面
     * @param string $cache 缓存名称
     * @author tang
     */
    function save($model='',$url='', $jump=true){
        $info = $this->_save($model);
        if ($info['status'] > 0) {
            if($url=='' && $jump==false)
                $this->success($info['message'],'');
            else
                $this->success($info['message'],$url ? U($url): U('index'));
        }else{
            $this->error($info['message']);
        }
    }
    /**
     * 删除跳转
     * @param string $url 跳转页面
     * @param string $cache 缓存名称
     * @author tang
     */
    function del($model='',$url=''){
        $info = $this->_delete($model);
        if ($info['status'] > 0) {
            $this->success($info['message'],$url ? U($url): U('index'));
        }else{
            $this->error($info['message']);
        }
    }


    /**
     * 获取单条具体信息
     * @param string $obj 对象名称 默认当前控制器名称
     * @author tang
     */
    function getInfo($obj = CONTROLLER_NAME,$rela=false){
        $info = array();
        $model = M($obj);
        if($rela){
            $model = D($obj)->relation(true);
        }
        $info = $model->find(I('get.id'));
        return $info;
    }
    /**
     * 获取数量
     * @param string $obj 对象名称 默认当前控制器名称
     * @param map $map 查询条件
     * @author tang
     */
    function getCount($obj = CONTROLLER_NAME,$map=array()){
        $count = 0;
        if($obj){
            $model = M($obj);
            $count = $model->where($map)->count();
        }
        return $count;
    }
    /**
     * 获取单个字段值
     * @param string $obj 对象名称 默认当前控制器名称
     * @param string $field  查询字段
     * @param map $map 查询条件
     * @author tang
     */
    function getValue($obj = CONTROLLER_NAME,$field='',$map=array()){

        $model = M($obj);
        if($map){
            $info = $model->field($field)->where($map)->find();
        }else{
            $id = I('id');
            $info = $model->field($field)->find($id);
        }

        return $info[$field];
    }


    // 获取所有记录
    function getAllRows($model=CONTROLLER_NAME,$field='',$map=array()){
        $map['status'] = array('gt',0);
        return M($model)->field($field)->where($map)->select();
    }


    /**
     * 添加页面
     * @author tang
     */
    function add(){
        $this->display();
    }
    /**
     * 修改页面
     * @param boole $rela 是否使用关联模型
     * @author tang
     */
    function edit($rela=0){
        $this->assign('info',$this->getInfo(CONTROLLER_NAME,$rela));
        $this->display('add');
    }
    function info($rela=0){
        $this->assign('info',$this->getInfo(CONTROLLER_NAME,$rela));
        $this->display();
    }
}
