<?php

namespace Api\Model;
use Think\Model;
use Common\Model\MemberModel;
use Org\Sms;

/**
 * 订单模型
 */
class OrderFinishModel extends Model{

    protected $_validate = array(
    	array('out_trade_no', 'require', '{%order_num_empty}', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
    	array('out_trade_no', '', '{%order_num_exsit}', self::EXISTS_VALIDATE, 'unique'),
    );

    protected $_auto = array(
        array('createtime', NOW_TIME, self::MODEL_INSERT),
        array('updatetime', NOW_TIME, self::MODEL_BOTH),
    );


    public function insert($orderInfo){
        $data = array(
            'out_trade_no' => $orderInfo['out_trade_no'],
            'total_fee' => $orderInfo['total_fee'],
            'balance' => $orderInfo['balance'],
            'credits' => $orderInfo['credits'],
            'coupon' => $orderInfo['coupon'],
        	'discount' => $orderInfo['discount'],
            'pay_fee' => $orderInfo['pay_fee'],
            'pay_plus' => $orderInfo['pay_plus'],
            'pay_type' => $orderInfo['pay_type'],
            'amount' => $orderInfo['pay_fee']+$orderInfo['pay_plus']+$orderInfo['balance'],
            'fac_id' => $orderInfo['fac_id'],
            'mid' => $orderInfo['mid']
        );
        if($data =$this->create($data)){
            $this->add($data);
            return true;
        }else{
            return false;
        }
    }



}
