<?php
namespace Merchant\Controller;

/**
 * 商品控制器
 */
class GoodsController extends AdminController {


    /**
     * 商品列表页
     */
    public function index(){

    	$keywords = I('keywords');
    	if(!empty($keywords)){
    		$map['title'] = array('like', '%'.(string)$keywords.'%');
    	}
        $map['status'] = array('in','1,0');
        $map['mid'] = UID;
        $list   = $this->lists(CONTROLLER_NAME, $map);

        $this->assign('_list', $list);
        $this->meta_title = 'Goods List';
        $this->display();
    }



    /**
     * 商品编辑页面
     */
    public function edit(){
    	if(IS_POST){
            $this->save(CONTROLLER_NAME,'index');

        } else {
            $info = $this->getInfo(CONTROLLER_NAME);
            
            $cates = D('Category')->lists();

            $this->assign('info',$info);
            $this->assign('cates',$cates);
            $this->meta_title = empty($info)? 'New goods':'Edit goods' ;
            $this->display();
        }
    }

}