<?php
    session_start();
    header('Cache-control: private'); // IE 6 FIX

    if (isSet($_GET['lang'])) {
        $lang = $_GET['lang'];

        $_SESSION['lang'] = $lang;
        setcookie("lang", $lang, time() + (3600 * 24 * 30));

    } else if (isSet($_SESSION['lang'])) {
        $lang = $_SESSION['lang'];
    } else if(isSet($_COOKIE['lang'])) {
        $lang = $_COOKIE['lang'];
    } else {
        $lang = 'en';
    }

    switch ($lang) {
        case 'en':
            $lang_file = 'en.php';
            break;

        case 'th':
            $lang_file = 'th.php';
            break;

        case 'jp':
            $lang_file = 'jp.php';
            break;

        case 'kr':
            $lang_file = 'kr.php';
            break;

        case 'cn':
            $lang_file = 'cn.php';
            break;

        default:
            $lang_file = 'en.php';
    }

    include_once 'lang/'.$lang_file;
?>