<?php

get_header();
the_post();
$image = get_feature_image(get_the_ID());
$categories = get_the_category();
$category = $categories[0];
set_query_var('category_id', absint($category->term_id));
?>
    <div class="block-section bg-white">
        <div class="container">
            <h1 class="mb-0 block-section-title h2 text-primary text-center"><?php the_title(); ?></h1>
            <div class="mb-3 text-muted text-center">
                <small>โพสเมื่อ : <?php the_date(); ?> <?php the_time(); ?> หมวดหมู่:
                    <a href="<?php echo get_category_link($category) ?>" class="text-primary"><u><?= $category->name; ?></u></a></small>
            </div>
            <p class="text-center"><?php echo get_custom_field('caption'); ?></p>
            <div class="page-content mb-5">
				<?php if ($image) : ?>
                    <div class="mb-5 text-center">
                        <img src="<?php echo $image; ?>" alt="<?php the_title(); ?>">
                    </div>
				<?php endif; ?>
				<?php echo wpautop(get_the_content(), true) ?>
            </div>
            <hr/>
            <h2 class="h3 text-primary mb-4"><?php echo sprintf('%sอื่นๆ', $category->name); ?></h2>
			<?php get_template_part('part/blogs'); ?>
        </div>
    </div>
    <!--    <div class="block-section bg-secondary">-->
    <!--        <div class="container">-->
    <!---->
    <!--        </div>-->
    <!--    </div>-->

<?php get_footer();
